; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=infer-address-spaces %s | FileCheck %s

target triple = "nvptx64-nvidia-cuda"


define ptx_kernel i32 @test_kernel(ptr %a, ptr byval(i32) %b) {
; CHECK-LABEL: define ptx_kernel i32 @test_kernel(
; CHECK-SAME: ptr [[A:%.*]], ptr byval(i32) [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[A]] to ptr addrspace(1)
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr addrspace(1) [[TMP1]], align 4
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    [[SUM:%.*]] = add i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUM]]
;
  %v1 = load i32, ptr %a
  %v2 = load i32, ptr %b
  %sum = add i32 %v1, %v2
  ret i32 %sum
}

define i32 @test_device(ptr %a, ptr byval(i32) %b) {
; CHECK-LABEL: define i32 @test_device(
; CHECK-SAME: ptr [[A:%.*]], ptr byval(i32) [[B:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[B]] to ptr addrspace(5)
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr addrspace(5) [[TMP1]], align 4
; CHECK-NEXT:    [[SUM:%.*]] = add i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUM]]
;
  %v1 = load i32, ptr %a
  %v2 = load i32, ptr %b
  %sum = add i32 %v1, %v2
  ret i32 %sum
}
