; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 4
; This check verifies that stack depth instrumentation works correctly.
; RUN: opt < %s -passes='module(sancov-module)' -sanitizer-coverage-level=1 -sanitizer-coverage-stack-depth -S | FileCheck %s --check-prefixes=L1
; RUN: opt < %s -passes='module(sancov-module)' -sanitizer-coverage-level=3 -sanitizer-coverage-stack-depth -S -sanitizer-coverage-trace-pc-guard | FileCheck %s --check-prefixes=L3

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@__sancov_lowest_stack = thread_local global i64 0, align 8

;.
; L1: @__sancov_lowest_stack = thread_local(initialexec) global i64 -1, align 8
;.
; L3: @__sancov_lowest_stack = thread_local(initialexec) global i64 -1, align 8
; L3: @__sancov_gen_ = private global [1 x i32] zeroinitializer, section "__sancov_guards", comdat($foo), align 4
; L3: @__sancov_gen_.1 = private global [1 x i32] zeroinitializer, section "__sancov_guards", comdat($bar), align 4
; L3: @__sancov_gen_.2 = private global [1 x i32] zeroinitializer, section "__sancov_guards", comdat($_ZTW21__sancov_lowest_stack), align 4
; L3: @__start___sancov_guards = extern_weak hidden global i32
; L3: @__stop___sancov_guards = extern_weak hidden global i32
; L3: @llvm.global_ctors = appending global [1 x { i32, ptr, ptr }] [{ i32, ptr, ptr } { i32 2, ptr @sancov.module_ctor_trace_pc_guard, ptr @sancov.module_ctor_trace_pc_guard }]
; L3: @llvm.used = appending global [1 x ptr] [ptr @sancov.module_ctor_trace_pc_guard], section "llvm.metadata"
; L3: @llvm.compiler.used = appending global [3 x ptr] [ptr @__sancov_gen_, ptr @__sancov_gen_.1, ptr @__sancov_gen_.2], section "llvm.metadata"
;.
define i32 @foo() {
; L1-LABEL: define i32 @foo() {
; L1-NEXT:  entry:
; L1-NEXT:    ret i32 7
;
; L3-LABEL: define i32 @foo() comdat {
; L3-NEXT:  entry:
; L3-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr @__sancov_gen_) #[[ATTR2:[0-9]+]]
; L3-NEXT:    ret i32 7
;
entry:

  ret i32 7
}

define i32 @bar() {
; L1-LABEL: define i32 @bar() {
; L1-NEXT:  entry:
; L1-NEXT:    [[TMP0:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; L1-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[TMP0]] to i64
; L1-NEXT:    [[TMP2:%.*]] = load i64, ptr @__sancov_lowest_stack, align 8, !nosanitize [[META0:![0-9]+]]
; L1-NEXT:    [[TMP3:%.*]] = icmp ult i64 [[TMP1]], [[TMP2]]
; L1-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP5:%.*]], !prof [[PROF1:![0-9]+]]
; L1:       4:
; L1-NEXT:    store i64 [[TMP1]], ptr @__sancov_lowest_stack, align 8, !nosanitize [[META0]]
; L1-NEXT:    br label [[TMP5]]
; L1:       5:
; L1-NEXT:    [[CALL:%.*]] = call i32 @foo()
; L1-NEXT:    ret i32 [[CALL]]
;
; L3-LABEL: define i32 @bar() comdat {
; L3-NEXT:  entry:
; L3-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr @__sancov_gen_.1) #[[ATTR2]]
; L3-NEXT:    [[TMP0:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; L3-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[TMP0]] to i64
; L3-NEXT:    [[TMP2:%.*]] = load i64, ptr @__sancov_lowest_stack, align 8, !nosanitize [[META0:![0-9]+]]
; L3-NEXT:    [[TMP3:%.*]] = icmp ult i64 [[TMP1]], [[TMP2]]
; L3-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP5:%.*]], !prof [[PROF1:![0-9]+]]
; L3:       4:
; L3-NEXT:    store i64 [[TMP1]], ptr @__sancov_lowest_stack, align 8, !nosanitize [[META0]]
; L3-NEXT:    br label [[TMP5]]
; L3:       5:
; L3-NEXT:    [[CALL:%.*]] = call i32 @foo()
; L3-NEXT:    ret i32 [[CALL]]
;
entry:

  %call = call i32 @foo()
  ret i32 %call
}

define weak_odr hidden ptr @_ZTW21__sancov_lowest_stack() {
; L1-LABEL: define weak_odr hidden ptr @_ZTW21__sancov_lowest_stack() {
; L1-NEXT:    ret ptr @__sancov_lowest_stack
;
; L3-LABEL: define weak_odr hidden ptr @_ZTW21__sancov_lowest_stack() comdat {
; L3-NEXT:    call void @__sanitizer_cov_trace_pc_guard(ptr @__sancov_gen_.2) #[[ATTR2]]
; L3-NEXT:    ret ptr @__sancov_lowest_stack
;
  ret ptr @__sancov_lowest_stack
}
;.
; L1: attributes #[[ATTR0:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(none) }
;.
; L3: attributes #[[ATTR0:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(none) }
; L3: attributes #[[ATTR1:[0-9]+]] = { nounwind }
; L3: attributes #[[ATTR2]] = { nomerge }
;.
; L1: [[META0]] = !{}
; L1: [[PROF1]] = !{!"branch_weights", i32 1, i32 1048575}
;.
; L3: [[META0]] = !{}
; L3: [[PROF1]] = !{!"branch_weights", i32 1, i32 1048575}
;.
