; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=hwasan -S | FileCheck %s
; RUN: opt < %s -passes=hwasan -hwasan-recover=0 -hwasan-mapping-offset=0 -S | FileCheck %s --check-prefixes=ABORT-ZERO-BASED-SHADOW

; This shows that HWASan omits the memaccess check when dereferencing a null
; pointer.
; The output is used as the source for llvm/test/CodeGen/AArch64/hwasan-zero-ptr.ll.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android10000"

define void @test_store_to_zeroptr() sanitize_hwaddress {
; CHECK-LABEL: define void @test_store_to_zeroptr
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr @__hwasan_shadow)
; CHECK-NEXT:    [[B:%.*]] = inttoptr i64 0 to ptr
; CHECK-NEXT:    store i64 42, ptr [[B]], align 8
; CHECK-NEXT:    ret void
;
; ABORT-ZERO-BASED-SHADOW-LABEL: define void @test_store_to_zeroptr
; ABORT-ZERO-BASED-SHADOW-SAME: () #[[ATTR0:[0-9]+]] {
; ABORT-ZERO-BASED-SHADOW-NEXT:  entry:
; ABORT-ZERO-BASED-SHADOW-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; ABORT-ZERO-BASED-SHADOW-NEXT:    [[B:%.*]] = inttoptr i64 0 to ptr
; ABORT-ZERO-BASED-SHADOW-NEXT:    store i64 42, ptr [[B]], align 8
; ABORT-ZERO-BASED-SHADOW-NEXT:    ret void
;
entry:
  %b = inttoptr i64 0 to i64*
  store i64 42, ptr %b
  ret void
}
