; RUN: llc <%s --mtriple s390x-ibm-zos --filetype=obj | \
; RUN:   od -Ax -tx1 -v | FileCheck --ignore-case %s

source_filename = "test.ll"

@data = hidden global i32 42, align 4
@bss = hidden global i64 0, align 8

; Header record:
;  03 is prefix byte
;  f. is header type
;  .0 is flag
;  00 is version
; The 1 at offset 0x33 is the architecture level.
; CHECK:      000000 03 f0 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000010 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000020 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000030 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000040 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

; ESD record, type SD.
;  03 is prefix byte
;  0. is header type
;  .0 is flag
;  00 is version
;  00 is type = SD
; The 01 at offset 0x57 is the id of the symbol.
; The 60 at offset 0x89 is the tasking behavior.
; The 01 at offset 0x91 is the binding scope.
; The name begins at offset 0x97, and is test#C.
; CHECK-NEXT: 000050 03 00 00 00 [[ROOTSD:00 00 00 01]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000060 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000070 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000080 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 60
; CHECK-NEXT: 000090 00 01 00 00 00 00 00 06 a3 85 a2 a3 7b c3 00 00

; ESD record, type ED.
; The name is C_CODE64.
; The regular expression matches the low byte of the length.
; CHECK-NEXT: 0000a0 03 00 00 01 [[C_CODE64:00 00 00 02]] [[ROOTSD]] 00 00 00 00
; CHECK-NEXT: 0000b0 00 00 00 00 00 00 00 00 00 00 00 {{..}} 00 00 00 00
; CHECK-NEXT: 0000c0 00 00 00 00 00 00 00 00 01 80 00 00 00 00 00 00
; CHECK-NEXT: 0000d0 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 08
; CHECK-NEXT: 0000e0 00 00 03 00 00 00 00 08 c3 6d c3 d6 c4 c5 f6 f4

; ESD record, type ED.
; The name is C_@@QPPA2.
; This record has a continuation, therefore the falg at offset 0xf1 is set.
; CHECK-NEXT: 0000f0 03 01 00 01 [[C_QPPA2:00 00 00 03]] [[ROOTSD]] 00 00 00 00
; CHECK-NEXT: 000100 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000110 00 00 00 00 00 00 00 00 03 80 00 00 00 00 00 00
; CHECK-NEXT: 000120 00 00 00 00 00 00 00 00 00 00 00 00 00 04 01 08
; CHECK-NEXT: 000130 00 00 03 00 00 00 00 09 c3 6d 7c 7c d8 d7 d7 c1
;
; Continuation:
; CHECK-NEXT: 000140 03 02 00 f2 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000150 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000160 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000170 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000180 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

; ESD record, type PR.
; The name is .&ppa2.
; CHECK-NEXT: 000190 03 00 00 03 [[PPA2:00 00 00 04]] [[C_QPPA2]] 00 00 00 00
; CHECK-NEXT: 0001a0 00 00 00 00 00 00 00 00 00 00 00 08 00 00 00 00
; CHECK-NEXT: 0001b0 00 00 00 00 00 00 00 00 03 20 00 00 00 00 00 00
; CHECK-NEXT: 0001c0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01
; CHECK-NEXT: 0001d0 00 01 03 00 00 00 00 06 4b 50 97 97 81 f2 00 00

; ESD record, type SD.
; The name is data.
; CHECK-NEXT: 0001e0 03 00 00 00 [[DATA:00 00 00 05]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0001f0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000200 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000210 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000220 00 00 00 00 00 00 00 04 84 81 a3 81 00 00 00 00

; ESD record, type ED.
; The name is C_WSA64.
; CHECK-NEXT: 000230 03 00 00 01 [[DATA_WSA:00 00 00 06]] [[DATA]] 00 00 00 00
; CHECK-NEXT: 000240 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000250 00 00 00 00 00 00 00 00 03 80 00 00 00 00 00 00
; CHECK-NEXT: 000260 00 00 00 00 00 00 00 00 00 00 00 00 00 04 01 00
; CHECK-NEXT: 000270 00 40 02 00 00 00 00 07 c3 6d e6 e2 c1 f6 f4 00

; ESD record, type PR.
; The name is data.
; CHECK-NEXT: 000280 03 00 00 03 [[DATA_PR:00 00 00 07]] [[DATA_WSA]] 00 00 00 00
; CHECK-NEXT: 000290 00 00 00 00 00 00 00 00 [[DATA_LEN:00 00 00 04]] 00 00 00 00
; CHECK-NEXT: 0002a0 00 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00
; CHECK-NEXT: 0002b0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01
; CHECK-NEXT: 0002c0 00 03 22 00 00 00 00 04 84 81 a3 81 00 00 00 00

; ESD record, type SD.
; The name is bss.
; CHECK-NEXT: 0002d0 03 00 00 00 [[BSS:00 00 00 08]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0002e0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0002f0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000300 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000310 00 00 00 00 00 00 00 03 82 a2 a2 00 00 00 00 00

; ESD record, type ED.
; The name is C_WSA64.
; CHECK-NEXT: 000320 03 00 00 01 [[BSS_WSA:00 00 00 09]] [[BSS]] 00 00 00 00
; CHECK-NEXT: 000330 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000340 00 00 00 00 00 00 00 00 03 80 00 00 00 00 00 00
; CHECK-NEXT: 000350 00 00 00 00 00 00 00 00 00 00 00 00 00 04 01 00
; CHECK-NEXT: 000360 00 40 03 00 00 00 00 07 c3 6d e6 e2 c1 f6 f4 00

; ESD record, type PR.
; The name is bss.
; CHECK-NEXT: 000370 03 00 00 03 [[BSS_PR:00 00 00 0a]] [[BSS_WSA]] 00 00 00 00
; CHECK-NEXT: 000380 00 00 00 00 00 00 00 00 [[BSS_LEN:00 00 00 08]] 00 00 00 00
; CHECK-NEXT: 000390 00 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00
; CHECK-NEXT: 0003a0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01
; CHECK-NEXT: 0003b0 00 03 23 00 00 00 00 03 82 a2 a2 00 00 00 00 00

; ESD record, type ED.
; The name is C_WSA64.
; CHECK-NEXT: 0003c0 03 00 00 01 [[C_WSA64:00 00 00 0b]] [[ROOTSD]] 00 00 00 00
; CHECK-NEXT: 0003d0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0003e0 00 00 00 00 00 00 00 00 03 81 00 00 00 00 00 00
; CHECK-NEXT: 0003f0 00 00 00 00 00 00 00 00 00 00 00 00 00 04 01 00
; CHECK-NEXT: 000400 00 40 04 00 00 00 00 07 c3 6d e6 e2 c1 f6 f4 00

; ESD record, type PR.
; The name is test#S.
; CHECK-NEXT: 000410 03 00 00 03 [[TESTS:00 00 00 0c]] [[C_WSA64]] 00 00 00 00
; CHECK-NEXT: 000420 00 00 00 00 00 00 00 00 00 00 00 {{..}} 00 00 00 00
; CHECK-NEXT: 000430 00 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00
; CHECK-NEXT: 000440 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01
; CHECK-NEXT: 000450 00 01 24 00 00 00 00 06 a3 85 a2 a3 7b e2 00 00

; ESD record, type ED.
; The name is B_IDRL.
; CHECK-NEXT: 000460 03 00 00 01 [[BIDRL:00 00 00 0d]] [[ROOTSD]] 00 00 00 00
; CHECK-NEXT: 000470 00 00 00 00 00 00 00 00 00 00 00 {{..}} 00 00 00 00
; CHECK-NEXT: 000480 00 00 00 00 00 00 00 00 01 80 00 00 00 00 00 00
; CHECK-NEXT: 000490 00 00 00 00 00 00 00 00 00 00 00 00 00 04 10 08
; CHECK-NEXT: 0004a0 00 80 03 00 00 00 00 06 c2 6d c9 c4 d9 d3 00 00

; ESD record, type LD.
; The name is test#C.
; CHECK-NEXT: 0004b0 03 00 00 02 [[TESTC:00 00 00 0e]] [[C_CODE64]] 00 00 00 00
; CHECK-NEXT: 0004c0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0004d0 00 00 00 00 00 00 00 00 01 00 00 00 [[TESTS]]
; CHECK-NEXT: 0004e0 00 00 00 00 00 00 00 00 00 00 00 00 04 00 00 02
; CHECK-NEXT: 0004f0 00 01 20 00 00 00 00 06 a3 85 a2 a3 7b c3 00 00

; Text record for the code section C_CODE64.
; The regular expression matches the lower byte of the length.
; CHECK-NEXT: 000500 03 10 00 00 [[C_CODE64]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000510 00 00 00 00 00 00 00 {{..}} {{.*}}

; Text record for the section .&ppa2.
; CHECK:      000550 03 10 00 00 [[PPA2]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000560 00 00 00 00 00 00 00 {{..}} {{.*}}

; Text record for the section data.
; Length is 4, and the content is 0x2a = 42.
; CHECK:      0005a0 03 10 00 00 [[DATA_PR]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 0005b0 00 00 00 00 00 00 00 04 00 00 00 2a 00 00 00 00

; There is no text record for section bss!

; Text record for the section B_IDRL.
; CHECK:      0005f0 03 10 00 01 [[BIDRL]] 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000600 00 00 00 00 00 00 00 {{..}} {{.*}}

; End record.
; CHECK:      000640 03 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000650 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000660 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000670 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
; CHECK-NEXT: 000680 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
