; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -march=nvptx64 -mcpu=sm_35 -mattr=+ptx50 | FileCheck %s --check-prefix=SM30
; RUN: %if ptxas && !ptxas-12.0 %{ llc < %s -march=nvptx64 -mcpu=sm_35 -mattr=+ptx50 | %ptxas-verify -arch=sm_35 %}
; RUN: llc < %s -march=nvptx64 -mcpu=sm_70 -mattr=+ptx60 | FileCheck %s --check-prefix=SM70
; RUN: %if ptxas %{ llc < %s -march=nvptx64 -mcpu=sm_70 -mattr=+ptx60 | %ptxas-verify -arch=sm_70 %}
; RUN: llc < %s -march=nvptx64 -mcpu=sm_90 -mattr=+ptx87 | FileCheck %s --check-prefix=SM90
; RUN: %if ptxas-12.8 %{ llc < %s -march=nvptx64 -mcpu=sm_90 -mattr=+ptx87 | %ptxas-verify -arch=sm_90 %}

define void @fence_acquire_sys() {
; SM30-LABEL: fence_acquire_sys(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.sys;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acquire_sys(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.sys;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acquire_sys(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acquire.sys;
; SM90-NEXT:    ret;
    fence syncscope("") acquire
    ret void
}


define void @fence_acquire_cta() {
; SM30-LABEL: fence_acquire_cta(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.cta;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acquire_cta(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.cta;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acquire_cta(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acquire.cta;
; SM90-NEXT:    ret;
    fence syncscope("block") acquire
    ret void
}


define void @fence_acquire_gpu() {
; SM30-LABEL: fence_acquire_gpu(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.gl;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acquire_gpu(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.gpu;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acquire_gpu(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acquire.gpu;
; SM90-NEXT:    ret;
    fence syncscope("device") acquire
    ret void
}


define void @fence_release_sys() {
; SM30-LABEL: fence_release_sys(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.sys;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_release_sys(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.sys;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_release_sys(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.release.sys;
; SM90-NEXT:    ret;
    fence syncscope("") release
    ret void
}


define void @fence_release_cta() {
; SM30-LABEL: fence_release_cta(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.cta;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_release_cta(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.cta;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_release_cta(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.release.cta;
; SM90-NEXT:    ret;
    fence syncscope("block") release
    ret void
}


define void @fence_release_gpu() {
; SM30-LABEL: fence_release_gpu(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.gl;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_release_gpu(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.gpu;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_release_gpu(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.release.gpu;
; SM90-NEXT:    ret;
    fence syncscope("device") release
    ret void
}


define void @fence_acq_rel_sys() {
; SM30-LABEL: fence_acq_rel_sys(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.sys;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acq_rel_sys(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.sys;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acq_rel_sys(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acq_rel.sys;
; SM90-NEXT:    ret;
    fence syncscope("") acq_rel
    ret void
}


define void @fence_acq_rel_cta() {
; SM30-LABEL: fence_acq_rel_cta(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.cta;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acq_rel_cta(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.cta;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acq_rel_cta(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acq_rel.cta;
; SM90-NEXT:    ret;
    fence syncscope("block") acq_rel
    ret void
}


define void @fence_acq_rel_gpu() {
; SM30-LABEL: fence_acq_rel_gpu(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.gl;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_acq_rel_gpu(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.acq_rel.gpu;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_acq_rel_gpu(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.acq_rel.gpu;
; SM90-NEXT:    ret;
    fence syncscope("device") acq_rel
    ret void
}


define void @fence_seq_cst_sys() {
; SM30-LABEL: fence_seq_cst_sys(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.sys;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_seq_cst_sys(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.sc.sys;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_seq_cst_sys(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.sc.sys;
; SM90-NEXT:    ret;
    fence syncscope("") seq_cst
    ret void
}


define void @fence_seq_cst_cta() {
; SM30-LABEL: fence_seq_cst_cta(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.cta;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_seq_cst_cta(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.sc.cta;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_seq_cst_cta(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.sc.cta;
; SM90-NEXT:    ret;
    fence syncscope("block") seq_cst
    ret void
}


define void @fence_seq_cst_gpu() {
; SM30-LABEL: fence_seq_cst_gpu(
; SM30:       {
; SM30-EMPTY:
; SM30-EMPTY:
; SM30-NEXT:  // %bb.0:
; SM30-NEXT:    membar.gl;
; SM30-NEXT:    ret;
;
; SM70-LABEL: fence_seq_cst_gpu(
; SM70:       {
; SM70-EMPTY:
; SM70-EMPTY:
; SM70-NEXT:  // %bb.0:
; SM70-NEXT:    fence.sc.gpu;
; SM70-NEXT:    ret;
;
; SM90-LABEL: fence_seq_cst_gpu(
; SM90:       {
; SM90-EMPTY:
; SM90-EMPTY:
; SM90-NEXT:  // %bb.0:
; SM90-NEXT:    fence.sc.gpu;
; SM90-NEXT:    ret;
    fence syncscope("device") seq_cst
    ret void
}

