; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck %s -check-prefixes=GFX942-SDAG
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck %s -check-prefixes=GFX942-GISEL
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck %s -check-prefixes=GFX11-SDAG,GFX11-SDAG-TRUE16
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck %s -check-prefixes=GFX11-SDAG,GFX11-SDAG-FAKE16
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck %s -check-prefixes=GFX11-GISEL,GFX11-GISEL-TRUE16
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck %s -check-prefixes=GFX11-GISEL,GFX11-GISEL-FAKE16
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck %s -check-prefixes=GFX12-SDAG,GFX12-SDAG-TRUE16
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck %s -check-prefixes=GFX12-SDAG,GFX12-SDAG-FAKE16
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck %s -check-prefixes=GFX12-GISEL,GFX12-GISEL-TRUE16
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck %s -check-prefixes=GFX12-GISEL,GFX12-GISEL-FAKE16

; Test flat scratch SVS addressing mode with various combinations of alignment
; of soffset, voffset and inst_offset.

declare i32 @llvm.amdgcn.workitem.id.x()

define amdgpu_kernel void @soff1_voff1(i32 %soff) {
; GFX942-SDAG-LABEL: soff1_voff1:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-SDAG-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff1_voff1:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff1_voff1:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 1, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v4, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff1_voff1:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v3, 4 :: v_dual_add_nc_u32 v0, s0, v0
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff1_voff1:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff1_voff1:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff1_voff1:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff1
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff1_voff2(i32 %soff) {
; GFX942-SDAG-LABEL: soff1_voff2:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 2, s0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-SDAG-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff1_voff2:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff1_voff2:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 1, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v4, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff1_voff2:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff1_voff2:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 2, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff1_voff2:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff1_voff2:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff2
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff1_voff4(i32 %soff) {
; GFX942-SDAG-LABEL: soff1_voff4:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 4, s0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-SDAG-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff1_voff4:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff1_voff4:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 1, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v4, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff1_voff4:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff1_voff4:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 4, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff1_voff4:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff1_voff4:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff4
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff2_voff1(i32 %soff) {
; GFX942-SDAG-LABEL: soff2_voff1:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-SDAG-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff2_voff1:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff2_voff1:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 1, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v4, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff2_voff1:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff2_voff1:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v1, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff2_voff1:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v3, 4 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff2_voff1:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff1
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff2_voff2(i32 %soff) {
; GFX942-SDAG-LABEL: soff2_voff2:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 2, s0
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off offset:1 sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff2_voff2:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff2_voff2:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, off offset:1 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff2_voff2:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff2_voff2:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 2, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff2_voff2:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff2_voff2:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff2
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff2_voff4(i32 %soff) {
; GFX942-SDAG-LABEL: soff2_voff4:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 4, s0
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off offset:1 sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff2_voff4:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff2_voff4:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, off offset:1 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff2_voff4:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff2_voff4:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 4, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff2_voff4:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff2_voff4:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff4
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff4_voff1(i32 %soff) {
; GFX942-SDAG-LABEL: soff4_voff1:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-SDAG-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff4_voff1:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v3, 2, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v3, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff4_voff1:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 1, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v4, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff4_voff1:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff4_voff1:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v1, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff4_voff1:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v3, 4 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff4_voff1:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff1
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff4_voff2(i32 %soff) {
; GFX942-SDAG-LABEL: soff4_voff2:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 2, s0
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off offset:1 sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff4_voff2:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff4_voff2:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 2, v2
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, off offset:1 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v3, v0, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff4_voff2:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v4, v2, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v5, v3, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff4_voff2:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 2, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff4_voff2:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff4_voff2:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 2, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff2
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff4_voff4(i32 %soff) {
; GFX942-SDAG-LABEL: soff4_voff4:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-SDAG-NEXT:    v_mad_u32_u24 v0, v0, 4, s0
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off offset:1 sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v2, off offset:2 sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff4_voff4:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-GISEL-NEXT:    v_add_u32_e32 v2, 1, v0
; GFX942-GISEL-NEXT:    scratch_store_byte v2, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v1, 2, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v2, 2
; GFX942-GISEL-NEXT:    scratch_store_byte v1, v2, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    v_add_u32_e32 v0, 4, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff4_voff4:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v2, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 4, v2
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, off offset:1 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, off offset:2 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v3, v1, off dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff4_voff4:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_mov_b32_e32 v4, 4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v3, 4, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, off offset:2 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v3, v4, off dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_add_nc_u32 v5, 2, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v4, v1, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v5, v2, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff4_voff4:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, 2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_u32_u24_e32 v2, 4, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v0, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_d16_hi_b8 v2, v0, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v2, v1, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff4_voff4:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff4_voff4:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, 2 :: v_dual_mov_b32 v3, 4
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_mul_u32_u24_e32 v0, 4, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff4
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 1
  store volatile i8 1, ptr addrspace(5) %p1
  %p2 = getelementptr i8, ptr addrspace(5) %asv, i32 2
  store volatile i8 2, ptr addrspace(5) %p2
  %p4 = getelementptr i8, ptr addrspace(5) %asv, i32 4
  store volatile i8 4, ptr addrspace(5) %p4
  ret void
}

define amdgpu_kernel void @soff1_voff1_negative(i32 %soff) {
; GFX942-SDAG-LABEL: soff1_voff1_negative:
; GFX942-SDAG:       ; %bb.0: ; %bb
; GFX942-SDAG-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-SDAG-NEXT:    v_add_u32_e32 v0, -1, v0
; GFX942-SDAG-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX942-SDAG-NEXT:    s_endpgm
;
; GFX942-GISEL-LABEL: soff1_voff1_negative:
; GFX942-GISEL:       ; %bb.0: ; %bb
; GFX942-GISEL-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-GISEL-NEXT:    v_add3_u32 v0, s0, v0, -1
; GFX942-GISEL-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX942-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: soff1_voff1_negative:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX11-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add3_u32 v1, 0, s0, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-SDAG-TRUE16-NEXT:    scratch_store_b8 v1, v0, off offset:-1 dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: soff1_voff1_negative:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX11-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add3_u32 v0, 0, s0, v0
; GFX11-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff1_negative:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
;
; GFX12-SDAG-TRUE16-LABEL: soff1_voff1_negative:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %bb
; GFX12-SDAG-TRUE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    scratch_store_b8 v1, v0, s0 offset:-1 scope:SCOPE_SYS
; GFX12-SDAG-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX12-SDAG-FAKE16-LABEL: soff1_voff1_negative:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %bb
; GFX12-SDAG-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-SDAG-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    scratch_store_b8 v0, v1, s0 offset:-1 scope:SCOPE_SYS
; GFX12-SDAG-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: soff1_voff1_negative:
; GFX12-GISEL:       ; %bb.0: ; %bb
; GFX12-GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:-1 scope:SCOPE_SYS
; GFX12-GISEL-NEXT:    s_wait_storecnt 0x0
; GFX12-GISEL-NEXT:    s_endpgm
bb:
  %a = alloca [64 x i8], align 4, addrspace(5)
  %as = getelementptr i8, ptr addrspace(5) %a, i32 %soff
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %asv = getelementptr i8, ptr addrspace(5) %as, i32 %voff
  %p1 = getelementptr i8, ptr addrspace(5) %asv, i32 -1
  store volatile i8 1, ptr addrspace(5) %p1
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-GISEL-FAKE16: {{.*}}
; GFX11-GISEL-TRUE16: {{.*}}
; GFX11-SDAG: {{.*}}
; GFX12-GISEL-FAKE16: {{.*}}
; GFX12-GISEL-TRUE16: {{.*}}
; GFX12-SDAG: {{.*}}
