; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 < %s -o - | FileCheck %s --check-prefixes=CHECK-LE
; RUN: llc -mtriple=aarch64_be < %s -o - | FileCheck %s --check-prefixes=CHECK-BE

; Check that we use the correct offset mode for vector loads and stores, and in
; particular for big-endian we use ld1/st1 which only allows postindex immediate
; offset of the same size as the memory access size.
; FIXME: Currently we fail to make use of postindex register offset ld1/st1.

define [2 x ptr] @v8i8_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i8_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.8b }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i8>, ptr %ldptr, align 2
  store <8 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i8_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i8_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #8
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <8 x i8>, ptr %add.ldptr, align 2
  store <8 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i8_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i8_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    st1 { v0.8b }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i8>, ptr %ldptr, align 2
  store <8 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i8_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i8_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <8 x i8>, ptr %add.ldptr, align 2
  store <8 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i8_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8i8_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.8b }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i8>, ptr %ldptr, align 2
  store <8 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i8_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8i8_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i8_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.8b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <8 x i8>, ptr %add.ldptr, align 2
  store <8 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i16_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i16>, ptr %ldptr, align 2
  store <4 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i16_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #8
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <4 x i16>, ptr %add.ldptr, align 2
  store <4 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i16_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    st1 { v0.4h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i16>, ptr %ldptr, align 2
  store <4 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i16_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <4 x i16>, ptr %add.ldptr, align 2
  store <4 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4i16_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.4h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i16>, ptr %ldptr, align 2
  store <4 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i16_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4i16_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i16_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <4 x i16>, ptr %add.ldptr, align 2
  store <4 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i32_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i32>, ptr %ldptr, align 2
  store <2 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i32_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #8
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <2 x i32>, ptr %add.ldptr, align 2
  store <2 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i32_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    st1 { v0.2s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i32>, ptr %ldptr, align 2
  store <2 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i32_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <2 x i32>, ptr %add.ldptr, align 2
  store <2 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2i32_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.2s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i32>, ptr %ldptr, align 2
  store <2 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i32_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2i32_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i32_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <2 x i32>, ptr %add.ldptr, align 2
  store <2 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1i64_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.1d }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.1d }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x i64>, ptr %ldptr, align 2
  store <1 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1i64_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0, #8]!
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    str d0, [x8, #8]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <1 x i64>, ptr %add.ldptr, align 2
  store <1 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1i64_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0], #16
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    str d0, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x i64>, ptr %ldptr, align 2
  store <1 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1i64_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0, #16]!
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    str d0, [x8, #16]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <1 x i64>, ptr %add.ldptr, align 2
  store <1 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v1i64_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    str d0, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x i64>, ptr %ldptr, align 2
  store <1 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1i64_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v1i64_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1i64_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    ldr d0, [x0, x2]
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    str d0, [x8, x2]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <1 x i64>, ptr %add.ldptr, align 2
  store <1 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f16_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x half>, ptr %ldptr, align 2
  store <4 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f16_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #8
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <4 x half>, ptr %add.ldptr, align 2
  store <4 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f16_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    st1 { v0.4h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x half>, ptr %ldptr, align 2
  store <4 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f16_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <4 x half>, ptr %add.ldptr, align 2
  store <4 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4f16_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.4h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x half>, ptr %ldptr, align 2
  store <4 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f16_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4f16_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f16_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.4h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <4 x half>, ptr %add.ldptr, align 2
  store <4 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f32_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x float>, ptr %ldptr, align 2
  store <2 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f32_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #8
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <2 x float>, ptr %add.ldptr, align 2
  store <2 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f32_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    st1 { v0.2s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x float>, ptr %ldptr, align 2
  store <2 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f32_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <2 x float>, ptr %add.ldptr, align 2
  store <2 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2f32_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.2s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x float>, ptr %ldptr, align 2
  store <2 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f32_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2f32_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f32_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <2 x float>, ptr %add.ldptr, align 2
  store <2 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1f64_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #8
; CHECK-LE-NEXT:    str d0, [x1], #8
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.1d }, [x0], #8
; CHECK-BE-NEXT:    st1 { v0.1d }, [x1], #8
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x double>, ptr %ldptr, align 2
  store <1 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1f64_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #8]!
; CHECK-LE-NEXT:    str d0, [x1, #8]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0, #8]!
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #8
; CHECK-BE-NEXT:    str d0, [x8, #8]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 8
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 8
  %val = load <1 x double>, ptr %add.ldptr, align 2
  store <1 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1f64_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0], #16
; CHECK-LE-NEXT:    str d0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0], #16
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    str d0, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x double>, ptr %ldptr, align 2
  store <1 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v1f64_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0, #16]!
; CHECK-LE-NEXT:    str d0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0, #16]!
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    str d0, [x8, #16]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <1 x double>, ptr %add.ldptr, align 2
  store <1 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v1f64_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr d0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ldr d0, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    str d0, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <1 x double>, ptr %ldptr, align 2
  store <1 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v1f64_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v1f64_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr d0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str d0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v1f64_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    ldr d0, [x0, x2]
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    str d0, [x8, x2]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <1 x double>, ptr %add.ldptr, align 2
  store <1 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v16i8_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.16b }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <16 x i8>, ptr %ldptr, align 2
  store <16 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v16i8_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.16b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <16 x i8>, ptr %add.ldptr, align 2
  store <16 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v16i8_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.16b }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <16 x i8>, ptr %ldptr, align 2
  store <16 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v16i8_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.16b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <16 x i8>, ptr %add.ldptr, align 2
  store <16 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v16i8_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.16b }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <16 x i8>, ptr %ldptr, align 2
  store <16 x i8> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v16i8_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v16i8_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v16i8_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.16b }, [x0]
; CHECK-BE-NEXT:    st1 { v0.16b }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <16 x i8>, ptr %add.ldptr, align 2
  store <16 x i8> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i16_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i16>, ptr %ldptr, align 2
  store <8 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i16_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <8 x i16>, ptr %add.ldptr, align 2
  store <8 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i16_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.8h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i16>, ptr %ldptr, align 2
  store <8 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8i16_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <8 x i16>, ptr %add.ldptr, align 2
  store <8 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8i16_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.8h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x i16>, ptr %ldptr, align 2
  store <8 x i16> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8i16_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8i16_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8i16_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <8 x i16>, ptr %add.ldptr, align 2
  store <8 x i16> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i32_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i32>, ptr %ldptr, align 2
  store <4 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i32_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <4 x i32>, ptr %add.ldptr, align 2
  store <4 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i32_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.4s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i32>, ptr %ldptr, align 2
  store <4 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4i32_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <4 x i32>, ptr %add.ldptr, align 2
  store <4 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4i32_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.4s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x i32>, ptr %ldptr, align 2
  store <4 x i32> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4i32_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4i32_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4i32_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <4 x i32>, ptr %add.ldptr, align 2
  store <4 x i32> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i64_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i64>, ptr %ldptr, align 2
  store <2 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i64_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <2 x i64>, ptr %add.ldptr, align 2
  store <2 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i64_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i64>, ptr %ldptr, align 2
  store <2 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2i64_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <2 x i64>, ptr %add.ldptr, align 2
  store <2 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2i64_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x i64>, ptr %ldptr, align 2
  store <2 x i64> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2i64_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2i64_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2i64_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <2 x i64>, ptr %add.ldptr, align 2
  store <2 x i64> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8f16_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x half>, ptr %ldptr, align 2
  store <8 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8f16_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <8 x half>, ptr %add.ldptr, align 2
  store <8 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8f16_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.8h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x half>, ptr %ldptr, align 2
  store <8 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v8f16_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <8 x half>, ptr %add.ldptr, align 2
  store <8 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8f16_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.8h }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <8 x half>, ptr %ldptr, align 2
  store <8 x half> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v8f16_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v8f16_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v8f16_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.8h }, [x0]
; CHECK-BE-NEXT:    st1 { v0.8h }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <8 x half>, ptr %add.ldptr, align 2
  store <8 x half> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f32_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x float>, ptr %ldptr, align 2
  store <4 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f32_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <4 x float>, ptr %add.ldptr, align 2
  store <4 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f32_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.4s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x float>, ptr %ldptr, align 2
  store <4 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v4f32_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <4 x float>, ptr %add.ldptr, align 2
  store <4 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4f32_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.4s }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <4 x float>, ptr %ldptr, align 2
  store <4 x float> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v4f32_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v4f32_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v4f32_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.4s }, [x0]
; CHECK-BE-NEXT:    st1 { v0.4s }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <4 x float>, ptr %add.ldptr, align 2
  store <4 x float> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_postidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f64_postidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #16
; CHECK-LE-NEXT:    str q0, [x1], #16
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_postidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0], #16
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1], #16
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x double>, ptr %ldptr, align 2
  store <2 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_preidx_same_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f64_preidx_same_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #16]!
; CHECK-LE-NEXT:    str q0, [x1, #16]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_preidx_same_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #16
; CHECK-BE-NEXT:    add x1, x1, #16
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 16
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 16
  %val = load <2 x double>, ptr %add.ldptr, align 2
  store <2 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_postidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f64_postidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0], #32
; CHECK-LE-NEXT:    str q0, [x1], #32
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_postidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    st1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x double>, ptr %ldptr, align 2
  store <2 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_preidx_different_size(ptr %ldptr, ptr %stptr) {
; CHECK-LE-LABEL: v2f64_preidx_different_size:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0, #32]!
; CHECK-LE-NEXT:    str q0, [x1, #32]!
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_preidx_different_size:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, #32
; CHECK-BE-NEXT:    add x1, x1, #32
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 32
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 32
  %val = load <2 x double>, ptr %add.ldptr, align 2
  store <2 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_postidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2f64_postidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    ldr q0, [x0]
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_postidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    mov x8, x1
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    st1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    ret
entry:
  %val = load <2 x double>, ptr %ldptr, align 2
  store <2 x double> %val, ptr %stptr, align 2
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}

define [2 x ptr] @v2f64_preidx_reg(ptr %ldptr, ptr %stptr, i64 %off) {
; CHECK-LE-LABEL: v2f64_preidx_reg:
; CHECK-LE:       // %bb.0: // %entry
; CHECK-LE-NEXT:    mov x8, x1
; CHECK-LE-NEXT:    ldr q0, [x0, x2]
; CHECK-LE-NEXT:    add x0, x0, x2
; CHECK-LE-NEXT:    add x1, x1, x2
; CHECK-LE-NEXT:    str q0, [x8, x2]
; CHECK-LE-NEXT:    ret
;
; CHECK-BE-LABEL: v2f64_preidx_reg:
; CHECK-BE:       // %bb.0: // %entry
; CHECK-BE-NEXT:    add x0, x0, x2
; CHECK-BE-NEXT:    add x1, x1, x2
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x0]
; CHECK-BE-NEXT:    st1 { v0.2d }, [x1]
; CHECK-BE-NEXT:    ret
entry:
  %add.ldptr = getelementptr inbounds nuw i8, ptr %ldptr, i64 %off
  %add.stptr = getelementptr inbounds nuw i8, ptr %stptr, i64 %off
  %val = load <2 x double>, ptr %add.ldptr, align 2
  store <2 x double> %val, ptr %add.stptr, align 2
  %ret1 = insertvalue [2 x ptr] poison, ptr %add.ldptr, 0
  %ret2 = insertvalue [2 x ptr] %ret1, ptr %add.stptr, 1
  ret [2 x ptr] %ret2
}
