; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple aarch64 -mattr=+sve -aarch64-enable-gisel-sve=1  | FileCheck %s
; RUN: llc < %s -mtriple aarch64 -mattr=+sve -global-isel -aarch64-enable-gisel-sve=1 | FileCheck %s

;; add
define <vscale x 2 x i64> @addnxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: addnxv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = add <vscale x 2 x i64> %a, %b
  ret <vscale x 2 x i64> %c
}

define <vscale x 4 x i32> @addnxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: addnxv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = add <vscale x 4 x i32> %a, %b
  ret <vscale x 4 x i32> %c
}

define <vscale x 8 x i16> @addnxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, ptr %p) {
; CHECK-LABEL: addnxv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = add <vscale x 8 x i16> %a, %b
  ret <vscale x 8 x i16> %c
}

define <vscale x 16 x i8> @addnxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: addnxv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = add <vscale x 16 x i8> %a, %b
  ret <vscale x 16 x i8> %c
}

;; sub
define <vscale x 2 x i64> @subnxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: subnxv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = sub <vscale x 2 x i64> %a, %b
  ret <vscale x 2 x i64> %c
}

define <vscale x 4 x i32> @subnxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: subnxv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %c = sub <vscale x 4 x i32> %a, %b
  ret <vscale x 4 x i32> %c
}

define <vscale x 8 x i16> @subnxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, ptr %p) {
; CHECK-LABEL: subnxv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
entry:
  %c = sub <vscale x 8 x i16> %a, %b
  ret <vscale x 8 x i16> %c
}

define <vscale x 16 x i8> @subnxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: subnxv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
entry:
  %c = sub <vscale x 16 x i8> %a, %b
  ret <vscale x 16 x i8> %c
}

;; and
define <vscale x 2 x i64> @andnxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: andnxv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = and <vscale x 2 x i64> %a, %b
  ret <vscale x 2 x i64> %c
}

define <vscale x 4 x i32> @andnxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: andnxv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = and <vscale x 4 x i32> %a, %b
  ret <vscale x 4 x i32> %c
}

define <vscale x 8 x i16> @andnxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, ptr %p) {
; CHECK-LABEL: andnxv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = and <vscale x 8 x i16> %a, %b
  ret <vscale x 8 x i16> %c
}

define <vscale x 16 x i8> @andnxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: andnxv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = and <vscale x 16 x i8> %a, %b
  ret <vscale x 16 x i8> %c
}

;; or
define <vscale x 2 x i64> @ornxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: ornxv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = or <vscale x 2 x i64> %a, %b
  ret <vscale x 2 x i64> %c
}

define <vscale x 4 x i32> @ornxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: ornxv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = or <vscale x 4 x i32> %a, %b
  ret <vscale x 4 x i32> %c
}

define <vscale x 8 x i16> @ornxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, ptr %p) {
; CHECK-LABEL: ornxv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = or <vscale x 8 x i16> %a, %b
  ret <vscale x 8 x i16> %c
}

define <vscale x 16 x i8> @ornxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: ornxv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = or <vscale x 16 x i8> %a, %b
  ret <vscale x 16 x i8> %c
}

;; xor
define <vscale x 2 x i64> @xornxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: xornxv2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = xor <vscale x 2 x i64> %a, %b
  ret <vscale x 2 x i64> %c
}

define <vscale x 4 x i32> @xornxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: xornxv4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = xor <vscale x 4 x i32> %a, %b
  ret <vscale x 4 x i32> %c
}

define <vscale x 8 x i16> @xornxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, ptr %p) {
; CHECK-LABEL: xornxv8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = xor <vscale x 8 x i16> %a, %b
  ret <vscale x 8 x i16> %c
}

define <vscale x 16 x i8> @xornxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: xornxv16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %c = xor <vscale x 16 x i8> %a, %b
  ret <vscale x 16 x i8> %c
}
