package org.freedesktop.gstreamer.examples.webrtcsrc

import android.os.Bundle
import android.os.PowerManager
import android.util.Log
import android.view.LayoutInflater
import android.view.SurfaceHolder
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat.getSystemService
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.navArgs
import androidx.preference.PreferenceManager
import com.google.android.material.snackbar.Snackbar
import org.freedesktop.gstreamer.examples.webrtcsrc.databinding.ConsumerFragmentBinding
import org.freedesktop.gstreamer.net.WebRTCSrc
import org.freedesktop.gstreamer.ui.GStreamerSurfaceView


class ConsumerFragment : Fragment(), WebRTCSrc.ErrorListener, SurfaceHolder.Callback {
    private var _binding: ConsumerFragmentBinding? = null
    private val binding get() = _binding!!
    // ConsumerFragmentArgs is generated by the androidx.navigation.safeargs plugin
    // from declarations in res/navigation/nav_graph.xml
    private val args: ConsumerFragmentArgs by navArgs()

    private lateinit var webRTCSrc: WebRTCSrc
    private lateinit var gsv: GStreamerSurfaceView

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {

        _binding = ConsumerFragmentBinding.inflate(inflater, container, false)

        WebRTCSrc.init(requireActivity())
        webRTCSrc = WebRTCSrc(this)

        getSystemService(requireActivity(), PowerManager::class.java)

        gsv = binding.surfaceVideo
        val sh = gsv.holder
        sh.addCallback(this)

        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.consumerProducerId.text = args.producerId
    }

    override fun onResume() {
        super.onResume()

        val prefs = PreferenceManager.getDefaultSharedPreferences(requireActivity())
        val signallerUri = prefs.getString("signaller_uri", getString(R.string.signaller_uri))!!
        val preferOpusHardwareDec = prefs.getBoolean("prefer_opus_hardware_decoder", false)

        webRTCSrc.startPipeline(signallerUri, args.producerId, preferOpusHardwareDec)
    }
    override fun onStop() {
        super.onStop()
        webRTCSrc.stopPipeline()
    }

    override fun onDestroyView() {
        webRTCSrc.close();
        super.onDestroyView()
        _binding = null
    }

    override fun onWebRTCSrcError(errorMessage: String) {
        requireActivity().runOnUiThread() {
            Snackbar.make(binding.root, errorMessage, Snackbar.LENGTH_LONG).show()
        }
    }

    override fun surfaceCreated(holder: SurfaceHolder) {
        Log.d("Consumer Fragment", "Surface created: $holder.surface");
    }

    override fun surfaceChanged(holder: SurfaceHolder, format: Int, width: Int, height: Int) {
        Log.d("Consumer Fragment", "Surface changed to format $format dimens $width x $height");
        webRTCSrc.setSurface(holder.surface);
    }

    override fun surfaceDestroyed(holder: SurfaceHolder) {
        Log.d("Consumer Fragment", "Surface destroyed");
        webRTCSrc.setSurface(null);
    }
}