; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -O0 -mtriple=riscv64 -mattr=+experimental-zicfilp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64 %s
; RUN: llc -O0 -mtriple=riscv64-unknown-linux-gnu -mattr=+experimental-zicfilp -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64-LINUX %s

declare void @llvm.init.trampoline(ptr, ptr, ptr)
declare ptr @llvm.adjust.trampoline(ptr)
declare i64 @f(ptr nest, i64)

define i64 @test0(i64 %n, ptr %p) nounwind {
; RV64-LABEL: test0:
; RV64:       # %bb.0:
; RV64-NEXT:    lpad 0
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64-NEXT:    lui a0, %hi(f)
; RV64-NEXT:    addi a0, a0, %lo(f)
; RV64-NEXT:    sw a0, 44(sp)
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    sw a0, 48(sp)
; RV64-NEXT:    sw a1, 36(sp)
; RV64-NEXT:    srli a0, a1, 32
; RV64-NEXT:    sw a0, 40(sp)
; RV64-NEXT:    li a0, 23
; RV64-NEXT:    sw a0, 16(sp)
; RV64-NEXT:    lui a0, 56
; RV64-NEXT:    addi a0, a0, 103
; RV64-NEXT:    sw a0, 32(sp)
; RV64-NEXT:    lui a0, 4324
; RV64-NEXT:    addi a0, a0, -509
; RV64-NEXT:    sw a0, 28(sp)
; RV64-NEXT:    lui a0, 6371
; RV64-NEXT:    addi a0, a0, 899
; RV64-NEXT:    sw a0, 24(sp)
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addi a0, a0, -489
; RV64-NEXT:    sw a0, 20(sp)
; RV64-NEXT:    addi a1, sp, 36
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64-NEXT:    call __clear_cache
; RV64-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld a1, 8(sp) # 8-byte Folded Reload
; RV64-NEXT:    jalr a1
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    ret
;
; RV64-LINUX-LABEL: test0:
; RV64-LINUX:       # %bb.0:
; RV64-LINUX-NEXT:    lpad 0
; RV64-LINUX-NEXT:    addi sp, sp, -64
; RV64-LINUX-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-LINUX-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64-LINUX-NEXT:    lui a0, %hi(f)
; RV64-LINUX-NEXT:    addi a0, a0, %lo(f)
; RV64-LINUX-NEXT:    sw a0, 44(sp)
; RV64-LINUX-NEXT:    srli a0, a0, 32
; RV64-LINUX-NEXT:    sw a0, 48(sp)
; RV64-LINUX-NEXT:    sw a1, 36(sp)
; RV64-LINUX-NEXT:    srli a0, a1, 32
; RV64-LINUX-NEXT:    sw a0, 40(sp)
; RV64-LINUX-NEXT:    li a0, 23
; RV64-LINUX-NEXT:    sw a0, 16(sp)
; RV64-LINUX-NEXT:    lui a0, 56
; RV64-LINUX-NEXT:    addi a0, a0, 103
; RV64-LINUX-NEXT:    sw a0, 32(sp)
; RV64-LINUX-NEXT:    lui a0, 4324
; RV64-LINUX-NEXT:    addi a0, a0, -509
; RV64-LINUX-NEXT:    sw a0, 28(sp)
; RV64-LINUX-NEXT:    lui a0, 6371
; RV64-LINUX-NEXT:    addi a0, a0, 899
; RV64-LINUX-NEXT:    sw a0, 24(sp)
; RV64-LINUX-NEXT:    lui a0, 1
; RV64-LINUX-NEXT:    addi a0, a0, -489
; RV64-LINUX-NEXT:    sw a0, 20(sp)
; RV64-LINUX-NEXT:    addi a1, sp, 36
; RV64-LINUX-NEXT:    addi a0, sp, 16
; RV64-LINUX-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64-LINUX-NEXT:    li a2, 0
; RV64-LINUX-NEXT:    call __riscv_flush_icache
; RV64-LINUX-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64-LINUX-NEXT:    ld a1, 8(sp) # 8-byte Folded Reload
; RV64-LINUX-NEXT:    jalr a1
; RV64-LINUX-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-LINUX-NEXT:    addi sp, sp, 64
; RV64-LINUX-NEXT:    ret
  %alloca = alloca [36 x i8], align 8
  call void @llvm.init.trampoline(ptr %alloca, ptr @f, ptr %p)
  %tramp = call ptr @llvm.adjust.trampoline(ptr %alloca)
  %ret = call i64 %tramp(i64 %n)
  ret i64 %ret
}

!llvm.module.flags = !{!0}

!0 = !{i32 8, !"cf-protection-branch", i32 1}
