; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <vscale x 16 x i8> @dup_insertelement_0(<vscale x 16 x i8> %v, i8 %s) #0 {
; CHECK-LABEL: @dup_insertelement_0(
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <vscale x 16 x i8> [[V:%.*]], i8 [[S:%.*]], i64 0
; CHECK-NEXT:    ret <vscale x 16 x i8> [[INSERT]]
;
  %pg = tail call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 1)
  %insert = tail call <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8> %v, <vscale x 16 x i1> %pg, i8 %s)
  ret <vscale x 16 x i8> %insert
}

define <vscale x 16 x i8> @dup_insertelement_1(<vscale x 16 x i8> %v, i8 %s) #0 {
; CHECK-LABEL: @dup_insertelement_1(
; CHECK-NEXT:    [[PG:%.*]] = tail call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 2)
; CHECK-NEXT:    [[INSERT:%.*]] = tail call <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8> [[V:%.*]], <vscale x 16 x i1> [[PG]], i8 [[S:%.*]])
; CHECK-NEXT:    ret <vscale x 16 x i8> [[INSERT]]
;
  %pg = tail call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 2)
  %insert = tail call <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8> %v, <vscale x 16 x i1> %pg, i8 %s)
  ret <vscale x 16 x i8> %insert
}

define <vscale x 16 x i8> @dup_insertelement_x(<vscale x 16 x i8> %v, i8 %s, <vscale x 16 x i1> %pg) #0 {
; CHECK-LABEL: @dup_insertelement_x(
; CHECK-NEXT:    [[INSERT:%.*]] = tail call <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8> [[V:%.*]], <vscale x 16 x i1> [[PG:%.*]], i8 [[S:%.*]])
; CHECK-NEXT:    ret <vscale x 16 x i8> [[INSERT]]
;
  %insert = tail call <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8> %v, <vscale x 16 x i1> %pg, i8 %s)
  ret <vscale x 16 x i8> %insert
}

define <vscale x 8 x i16> @dup_insertelement_0_convert(<vscale x 8 x i16> %v, i16 %s) #0 {
; CHECK-LABEL: @dup_insertelement_0_convert(
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <vscale x 8 x i16> [[V:%.*]], i16 [[S:%.*]], i64 0
; CHECK-NEXT:    ret <vscale x 8 x i16> [[INSERT]]
;
  %pg = tail call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 1)
  %1 = tail call <vscale x 16 x i1> @llvm.aarch64.sve.convert.to.svbool.nxv8i1(<vscale x 8 x i1> %pg)
  %2 = tail call <vscale x 8 x i1> @llvm.aarch64.sve.convert.from.svbool.nxv8i1(<vscale x 16 x i1> %1)
  %insert = tail call <vscale x 8 x i16> @llvm.aarch64.sve.dup.nxv8i16(<vscale x 8 x i16> %v, <vscale x 8 x i1> %2, i16 %s)
  ret <vscale x 8 x i16> %insert
}

define <vscale x 8 x i16> @dupx_splat_convert(i16 %s) #0 {
; CHECK-LABEL: @dupx_splat_convert(
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <vscale x 8 x i16> poison, i16 [[S:%.*]], i64 0
; CHECK-NEXT:    [[SPLAT:%.*]] = shufflevector <vscale x 8 x i16> [[DOTSPLATINSERT]], <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
; CHECK-NEXT:    ret <vscale x 8 x i16> [[SPLAT]]
;
  %splat = tail call <vscale x 8 x i16> @llvm.aarch64.sve.dup.x.nxv8i16(i16 %s)
  ret <vscale x 8 x i16> %splat
}

declare <vscale x 8 x i16> @llvm.aarch64.sve.dup.x.nxv8i16(i16)

declare <vscale x 16 x i8> @llvm.aarch64.sve.dup.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i1>, i8)
declare <vscale x 8 x i16> @llvm.aarch64.sve.dup.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i1>, i16)

declare <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32)
declare <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32)

declare <vscale x 16 x i1> @llvm.aarch64.sve.convert.to.svbool.nxv8i1(<vscale x 8 x i1>)
declare <vscale x 8 x i1> @llvm.aarch64.sve.convert.from.svbool.nxv8i1(<vscale x 16 x i1>)

attributes #0 = { "target-features"="+sve" }
