; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple thumbv8.1m.main-arm-none-eabihf -mattr=+mve | FileCheck %s

declare void @use_int32x4_t(<4 x i32>)

; A 256-bit addition, with the two halves of the result passed to function
; calls to spill the carry bit out of FPSCR.
define void @add_256(<4 x i32> %a_low, <4 x i32> %a_high, <4 x i32> %b_low, <4 x i32> %b_high) {
; CHECK-LABEL: add_256:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vadci.i32 q0, q0, q2
; CHECK-NEXT:    vmov q4, q3
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vstr fpscr_nzcvqc, [sp, #4] @ 4-byte Spill
; CHECK-NEXT:    bl use_int32x4_t
; CHECK-NEXT:    vldr fpscr_nzcvqc, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    vadc.i32 q0, q5, q4
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop.w {r7, lr}
; CHECK-NEXT:    b use_int32x4_t
entry:
  %adc_low = tail call { <4 x i32>, i32 } @llvm.arm.mve.vadc.v4i32(<4 x i32> %a_low, <4 x i32> %b_low, i32 0)
  %carry = extractvalue { <4 x i32>, i32 } %adc_low, 1
  %result_low = extractvalue { <4 x i32>, i32 } %adc_low, 0
  tail call void @use_int32x4_t(<4 x i32> %result_low)
  %adc_high = tail call { <4 x i32>, i32 } @llvm.arm.mve.vadc.v4i32(<4 x i32> %a_high, <4 x i32> %b_high, i32 %carry)
  %result_high = extractvalue { <4 x i32>, i32 } %adc_high, 0
  tail call void @use_int32x4_t(<4 x i32> %result_high)
  ret void
}

; A 256-bit subtraction, with the two halves of the result passed to function
; calls to spill the carry bit out of FPSCR.
define void @sub_256(<4 x i32> %a_low, <4 x i32> %a_high, <4 x i32> %b_low, <4 x i32> %b_high) {
; CHECK-LABEL: sub_256:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vsbci.i32 q0, q0, q2
; CHECK-NEXT:    vmov q4, q3
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vstr fpscr_nzcvqc, [sp, #4] @ 4-byte Spill
; CHECK-NEXT:    bl use_int32x4_t
; CHECK-NEXT:    vldr fpscr_nzcvqc, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    vsbc.i32 q0, q5, q4
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop.w {r7, lr}
; CHECK-NEXT:    b use_int32x4_t
entry:
  %adc_low = tail call { <4 x i32>, i32 } @llvm.arm.mve.vsbc.v4i32(<4 x i32> %a_low, <4 x i32> %b_low, i32 536870912)
  %carry = extractvalue { <4 x i32>, i32 } %adc_low, 1
  %result_low = extractvalue { <4 x i32>, i32 } %adc_low, 0
  tail call void @use_int32x4_t(<4 x i32> %result_low)
  %adc_high = tail call { <4 x i32>, i32 } @llvm.arm.mve.vsbc.v4i32(<4 x i32> %a_high, <4 x i32> %b_high, i32 %carry)
  %result_high = extractvalue { <4 x i32>, i32 } %adc_high, 0
  tail call void @use_int32x4_t(<4 x i32> %result_high)
  ret void
}

; The carry-out of the first VADC intrinsic call is used by two other VADCs,
; both of which will modify FPSCR, so it must be spilled and reloaded.
; Missed optimisation: the first VLDR isn't needed, because the carry bit is
; already in FPSCR.
define <4 x i32> @multiple_uses_of_carry_bit(<4 x i32> %a_low, <4 x i32> %a_high, <4 x i32> %b_low, <4 x i32> %b_high, <4 x i32> %a_high_2, <4 x i32> %b_high_2) {
; CHECK-LABEL: multiple_uses_of_carry_bit:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vadci.i32 q0, q0, q2
; CHECK-NEXT:    add r0, sp, #24
; CHECK-NEXT:    vstr fpscr_nzcvqc, [sp, #4] @ 4-byte Spill
; CHECK-NEXT:    vldr fpscr_nzcvqc, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    vadc.i32 q1, q1, q3
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    add r0, sp, #8
; CHECK-NEXT:    vldr fpscr_nzcvqc, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vadc.i32 q1, q2, q1
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    bx lr
entry:
  %adc_low = tail call { <4 x i32>, i32 } @llvm.arm.mve.vadc.v4i32(<4 x i32> %a_low, <4 x i32> %b_low, i32 0)
  %carry = extractvalue { <4 x i32>, i32 } %adc_low, 1
  %result_low = extractvalue { <4 x i32>, i32 } %adc_low, 0
  %adc_high = tail call { <4 x i32>, i32 } @llvm.arm.mve.vadc.v4i32(<4 x i32> %a_high, <4 x i32> %b_high, i32 %carry)
  %result_high = extractvalue { <4 x i32>, i32 } %adc_high, 0
  %checksum_1 = xor <4 x i32> %result_low, %result_high
  %adc_high_2 = tail call { <4 x i32>, i32 } @llvm.arm.mve.vadc.v4i32(<4 x i32> %a_high_2, <4 x i32> %b_high_2, i32 %carry)
  %result_high_2 = extractvalue { <4 x i32>, i32 } %adc_high_2, 0
  %checksum_2 = xor <4 x i32> %checksum_1, %result_high_2
  ret <4 x i32> %checksum_2
}
