; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx %s -o - | FileCheck %s


define void @load_zext_2i8_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_2i8_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.h $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i8>, ptr %ptr
  %B = zext <2 x i8> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_zext_4i8_to_4i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_4i8_to_4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i8>, ptr %ptr
  %B = zext <4 x i8> %A to <4 x i32>
  store <4 x i32> %B, ptr %dst
  ret void
}

define void @load_zext_8i8_to_8i16(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_8i8_to_8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i8>, ptr %ptr
  %B = zext <8 x i8> %A to <8 x i16>
  store <8 x i16> %B, ptr %dst
  ret void
}

define void @load_zext_2i16_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_2i16_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i16>, ptr %ptr
  %B = zext <2 x i16> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_zext_4i16_to_4i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_4i16_to_4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i16>, ptr %ptr
  %B = zext <4 x i16> %A to <4 x i32>
  store <4 x i32> %B, ptr %dst
  ret void
}

define void @load_zext_2i32_to_2i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_2i32_to_2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <2 x i32>, ptr %ptr
  %B = zext <2 x i32> %A to <2 x i64>
  store <2 x i64> %B, ptr %dst
  ret void
}

define void @load_zext_16i8_to_16i16(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_16i8_to_16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvh.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = zext <16 x i8> %A to <16 x i16>
  store <16 x i16> %B, ptr %dst
  ret void
}

define void @load_zext_16i8_to_16i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_16i8_to_16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr3, $vr1, $vr2
; CHECK-NEXT:    vilvh.h $vr2, $vr1, $vr2
; CHECK-NEXT:    vilvh.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr4, $vr1, $vr0
; CHECK-NEXT:    vilvh.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr4, $a1, 32
; CHECK-NEXT:    vst $vr2, $a1, 16
; CHECK-NEXT:    vst $vr3, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = zext <16 x i8> %A to <16 x i32>
  store <16 x i32> %B, ptr %dst
  ret void
}

define void @load_zext_16i8_to_16i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_16i8_to_16i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.b $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr3, $vr1, $vr2
; CHECK-NEXT:    vilvl.w $vr4, $vr1, $vr3
; CHECK-NEXT:    vilvh.w $vr3, $vr1, $vr3
; CHECK-NEXT:    vilvh.h $vr2, $vr1, $vr2
; CHECK-NEXT:    vilvl.w $vr5, $vr1, $vr2
; CHECK-NEXT:    vilvh.w $vr2, $vr1, $vr2
; CHECK-NEXT:    vilvh.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.h $vr6, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr7, $vr1, $vr6
; CHECK-NEXT:    vilvh.w $vr6, $vr1, $vr6
; CHECK-NEXT:    vilvh.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr8, $vr1, $vr0
; CHECK-NEXT:    vilvh.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 112
; CHECK-NEXT:    vst $vr8, $a1, 96
; CHECK-NEXT:    vst $vr6, $a1, 80
; CHECK-NEXT:    vst $vr7, $a1, 64
; CHECK-NEXT:    vst $vr2, $a1, 48
; CHECK-NEXT:    vst $vr5, $a1, 32
; CHECK-NEXT:    vst $vr3, $a1, 16
; CHECK-NEXT:    vst $vr4, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <16 x i8>, ptr %ptr
  %B = zext <16 x i8> %A to <16 x i64>
  store <16 x i64> %B, ptr %dst
  ret void
}

define void @load_zext_8i16_to_8i32(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_8i16_to_8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvh.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i16>, ptr %ptr
  %B = zext <8 x i16> %A to <8 x i32>
  store <8 x i32> %B, ptr %dst
  ret void
}

define void @load_zext_8i16_to_8i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_8i16_to_8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr3, $vr1, $vr2
; CHECK-NEXT:    vilvh.w $vr2, $vr1, $vr2
; CHECK-NEXT:    vilvh.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vilvl.w $vr4, $vr1, $vr0
; CHECK-NEXT:    vilvh.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr4, $a1, 32
; CHECK-NEXT:    vst $vr2, $a1, 16
; CHECK-NEXT:    vst $vr3, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <8 x i16>, ptr %ptr
  %B = zext <8 x i16> %A to <8 x i64>
  store <8 x i64> %B, ptr %dst
  ret void
}

define void @load_zext_4i32_to_4i64(ptr %ptr, ptr %dst) {
; CHECK-LABEL: load_zext_4i32_to_4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vrepli.b $vr1, 0
; CHECK-NEXT:    vilvl.w $vr2, $vr1, $vr0
; CHECK-NEXT:    vilvh.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
entry:
  %A = load <4 x i32>, ptr %ptr
  %B = zext <4 x i32> %A to <4 x i64>
  store <4 x i64> %B, ptr %dst
  ret void
}
