; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=bonaire < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s

define amdgpu_kernel void @atomic_add_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_add_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile add ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_add_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile add ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_add_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_add_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile add ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_add_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile add ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_add_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile add ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_add_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_add_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_add_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile add ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_add_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_add_u64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile add ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_add_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_add_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_add_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile add ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_and_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile and ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_and_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile and ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_and_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_and_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile and ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_and_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile and ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_and_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile and ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_and_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_and_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_and_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile and ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_and_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_and_b64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile and ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_and_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_and_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_and_b64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile and ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_sub_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile sub ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_sub_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile sub ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_sub_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_sub_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile sub ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_sub_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile sub ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_sub_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile sub ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_sub_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_sub_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_sub_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile sub ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_sub_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_sub_u64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile sub ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_sub_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_sub_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_sub_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile sub ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_max_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[2:3] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile max ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_max_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile max ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_max_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_i64 v[2:3], v[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_max_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[2:3] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_max_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_smax_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_smax_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_max_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_i64 v[2:3], v[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_max_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_max_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_i64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_umax_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_umax_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umax_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_umax_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[2:3] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_umax_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_umax_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_umax_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umax_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_u64 v[2:3], v[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umax_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umax_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_max_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_min_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[2:3] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile min ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_min_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile min ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_min_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_i64 v[2:3], v[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_min_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[2:3] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_min_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_smin_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_smin_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_min_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_i64 v[2:3], v[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_min_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_min_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_i64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_umin_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_umin_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umin_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr %gep, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_umin_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[2:3] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_umin_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_umin_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_umin_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr %out, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umin_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_u64 v[2:3], v[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_umin_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_umin_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_min_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr %ptr, i64 %in syncscope("workgroup") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_or_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile or ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_or_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile or ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_or_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_or_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile or ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_or_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile or ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_or_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile or ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_or_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_or_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_or_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile or ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_or_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_or_b64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile or ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_or_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_or_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_or_b64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile or ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_xchg_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_f64_offset(ptr %out, double %in) {
; GFX7-LABEL: atomic_xchg_f64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_f64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_f64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr double, ptr %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr %gep, double %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_pointer_offset(ptr %out, ptr %in) {
; GFX7-LABEL: atomic_xchg_pointer_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_pointer_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_pointer_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr ptr, ptr %out, i32 4
  %val = atomicrmw volatile xchg ptr %gep, ptr %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_xchg_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xchg_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_swap_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile xchg ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xchg_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile xchg ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_xchg_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xchg ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_xchg_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_swap_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_swap_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xchg ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xchg_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_swap_b64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile xchg ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xchg_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xchg_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_swap_b64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile xchg ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_xor_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile xor ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_xor_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile xor ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_addr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xor_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_xor_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile xor ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xor_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile xor ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_xor_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xor ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_xor_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_xor_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_xor_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xor ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_addr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xor_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_xor_b64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile xor ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_xor_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_xor_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_xor_b64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile xor ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_load_i64_offset(ptr %in, ptr %out) {
; GFX7-LABEL: atomic_load_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %in, i64 4
  %val = load atomic i64, ptr %gep  seq_cst, align 8
  store i64 %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64(ptr %in, ptr %out) {
; GFX7-LABEL: atomic_load_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %val = load atomic i64, ptr %in syncscope("agent") seq_cst, align 8
  store i64 %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64_addr64_offset(ptr %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_load_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %in, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %val = load atomic i64, ptr %gep seq_cst, align 8
  store i64 %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64_addr64(ptr %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_load_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %in, i64 %index
  %val = load atomic i64, ptr %ptr seq_cst, align 8
  store i64 %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_store_i64_offset(i64 %in, ptr %out) {
; GFX7-LABEL: atomic_store_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_add_u32 s0, s2, 32
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_addc_u32 s1, s3, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_add_u32 s0, s2, 32
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_addc_u32 s1, s3, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  store atomic i64 %in, ptr %gep  seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64(i64 %in, ptr %out) {
; GFX7-LABEL: atomic_store_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  store atomic i64 %in, ptr %out seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64_addr64_offset(i64 %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_store_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s2, s0
; GFX7-NEXT:    s_addc_u32 s1, s3, s1
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s2, s0
; GFX8-NEXT:    s_addc_u32 s1, s3, s1
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  store atomic i64 %in, ptr %gep seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64_addr64(i64 %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_store_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s2, s0
; GFX7-NEXT:    s_addc_u32 s1, s3, s1
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s2, s0
; GFX8-NEXT:    s_addc_u32 s1, s3, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  store atomic i64 %in, ptr %ptr seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_offset(ptr %out, i64 %in, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %val = cmpxchg volatile ptr %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_soffset(ptr %out, i64 %in, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_soffset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 0x11940
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_soffset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 0x11940
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_soffset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:3] offset:72000 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 9000
  %val = cmpxchg volatile ptr %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_offset(ptr %out, ptr %out2, i64 %in, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[0:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %val = cmpxchg volatile ptr %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_addr64_offset(ptr %out, i64 %in, i64 %index, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v5, s1 :: v_dual_mov_b32 v4, s0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %val = cmpxchg volatile ptr %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_addr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x11
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    s_add_u32 s0, s8, s2
; GFX7-NEXT:    s_addc_u32 s3, s9, s3
; GFX7-NEXT:    s_add_u32 s2, s0, 32
; GFX7-NEXT:    s_addc_u32 s3, s3, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_add_u32 s0, s8, s2
; GFX8-NEXT:    s_addc_u32 s3, s9, s3
; GFX8-NEXT:    s_add_u32 s2, s0, 32
; GFX8-NEXT:    s_addc_u32 s3, s3, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b256 s[8:15], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x44
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[8:9], s[2:3]
; GFX12-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_dual_mov_b32 v5, s3 :: v_dual_mov_b32 v4, s2
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[0:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s10 :: v_dual_mov_b32 v3, s11
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %val = cmpxchg volatile ptr %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64(ptr %out, i64 %in, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %val = cmpxchg volatile ptr %out, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret(ptr %out, ptr %out2, i64 %in, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s1
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[0:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %val = cmpxchg volatile ptr %out, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_addr64(ptr %out, i64 %in, i64 %index, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v5, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_mov_b32_e32 v4, s0
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_dual_mov_b32 v5, s1 :: v_dual_mov_b32 v4, s0
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[4:5], v[0:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %val = cmpxchg volatile ptr %ptr, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_addr64(ptr %out, ptr %out2, i64 %in, i64 %index, i64 %old) {
; GFX7-LABEL: atomic_cmpxchg_i64_ret_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x11
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX7-NEXT:    s_add_u32 s2, s8, s2
; GFX7-NEXT:    s_addc_u32 s3, s9, s3
; GFX7-NEXT:    v_mov_b32_e32 v5, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s12
; GFX7-NEXT:    v_mov_b32_e32 v1, s13
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v4, s2
; GFX7-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_cmpxchg_i64_ret_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX8-NEXT:    s_add_u32 s2, s8, s2
; GFX8-NEXT:    s_addc_u32 s3, s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s12
; GFX8-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b256 s[8:15], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[4:5], 0x44
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[2:3], s[14:15], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s12 :: v_dual_mov_b32 v1, s13
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[8:9], s[2:3]
; GFX12-NEXT:    v_dual_mov_b32 v2, s0 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_dual_mov_b32 v5, s3 :: v_dual_mov_b32 v4, s2
; GFX12-NEXT:    flat_atomic_cmpswap_b64 v[0:1], v[4:5], v[0:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s10 :: v_dual_mov_b32 v3, s11
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %val = cmpxchg volatile ptr %ptr, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst, !noalias.addrspace !0
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_load_f64_offset(ptr %in, ptr %out) {
; GFX7-LABEL: atomic_load_f64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_f64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_f64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr double, ptr %in, i64 4
  %val = load atomic double, ptr %gep  seq_cst, align 8, !noalias.addrspace !0
  store double %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_f64(ptr %in, ptr %out) {
; GFX7-LABEL: atomic_load_f64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_f64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_f64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %val = load atomic double, ptr %in syncscope("agent") seq_cst, align 8, !noalias.addrspace !0
  store double %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_f64_addr64_offset(ptr %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_load_f64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_f64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_f64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr %in, i64 %index
  %gep = getelementptr double, ptr %ptr, i64 4
  %val = load atomic double, ptr %gep seq_cst, align 8, !noalias.addrspace !0
  store double %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_load_f64_addr64(ptr %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_load_f64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_load_f64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_f64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    flat_load_b64 v[0:1], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr %in, i64 %index
  %val = load atomic double, ptr %ptr seq_cst, align 8, !noalias.addrspace !0
  store double %val, ptr %out
  ret void
}

define amdgpu_kernel void @atomic_store_f64_offset(double %in, ptr %out) {
; GFX7-LABEL: atomic_store_f64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_add_u32 s0, s2, 32
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_addc_u32 s1, s3, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_f64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_add_u32 s0, s2, 32
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_addc_u32 s1, s3, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_f64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr double, ptr %out, i64 4
  store atomic double %in, ptr %gep  seq_cst, align 8, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_store_f64(double %in, ptr %out) {
; GFX7-LABEL: atomic_store_f64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_f64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_f64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  store atomic double %in, ptr %out seq_cst, align 8, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_store_f64_addr64_offset(double %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_store_f64_addr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s2, s0
; GFX7-NEXT:    s_addc_u32 s1, s3, s1
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_f64_addr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s2, s0
; GFX8-NEXT:    s_addc_u32 s1, s3, s1
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_f64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr %out, i64 %index
  %gep = getelementptr double, ptr %ptr, i64 4
  store atomic double %in, ptr %gep seq_cst, align 8, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_store_f64_addr64(double %in, ptr %out, i64 %index) {
; GFX7-LABEL: atomic_store_f64_addr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s2, s0
; GFX7-NEXT:    s_addc_u32 s1, s3, s1
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_store_f64_addr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s2, s0
; GFX8-NEXT:    s_addc_u32 s1, s3, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_f64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    s_add_nc_u64 s[2:3], s[2:3], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr %out, i64 %index
  store atomic double %in, ptr %ptr seq_cst, align 8, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_inc_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_inc_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_incr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_inc_i64_incr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_incr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_incr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_inc_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_ret_incr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_inc_i64_ret_incr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_ret_incr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_ret_incr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_inc_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_inc_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile uinc_wrap ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_inc_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_inc_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_inc_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile uinc_wrap ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_incr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_inc_i64_incr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_incr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_incr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_inc_u64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile uinc_wrap ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_ret_incr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_inc_i64_ret_incr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_inc_i64_ret_incr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_inc_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_ret_incr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_inc_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile uinc_wrap ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_offset(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_dec_i64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[2:3] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_ret_offset(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_dec_i64_ret_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_ret_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[0:1], v[2:3] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr %out, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_decr64_offset(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_dec_i64_decr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_decr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_decr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_dec_u64 v[2:3], v[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_ret_decr64_offset(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_dec_i64_ret_decr64_offset:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    s_add_u32 s0, s0, 32
; GFX7-NEXT:    s_addc_u32 s1, s1, 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_ret_decr64_offset:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_add_u32 s0, s0, 32
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_ret_decr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[2:3], v[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %gep = getelementptr i64, ptr %ptr, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr %gep, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_dec_i64(ptr %out, i64 %in) {
; GFX7-LABEL: atomic_dec_i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[2:3] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile udec_wrap ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_ret(ptr %out, ptr %out2, i64 %in) {
; GFX7-LABEL: atomic_dec_i64_ret:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_atomic_dec_x2 v[0:1], v[0:1], v[2:3] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_ret:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_atomic_dec_x2 v[0:1], v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[0:1], v[2:3] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile udec_wrap ptr %out, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_decr64(ptr %out, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_dec_i64_decr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s2
; GFX7-NEXT:    s_addc_u32 s1, s1, s3
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_decr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_decr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[6:7], s[4:5], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_dec_u64 v[2:3], v[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile udec_wrap ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_ret_decr64(ptr %out, ptr %out2, i64 %in, i64 %index) {
; GFX7-LABEL: atomic_dec_i64_ret_decr64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX7-NEXT:    s_add_u32 s0, s0, s4
; GFX7-NEXT:    s_addc_u32 s1, s1, s5
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s0
; GFX7-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1_vol
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: atomic_dec_i64_ret_decr64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_atomic_dec_x2 v[0:1], v[2:3], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_ret_decr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[6:7], s[6:7], 3
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[6:7]
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v3, s1 :: v_dual_mov_b32 v2, s0
; GFX12-NEXT:    flat_atomic_dec_u64 v[0:1], v[2:3], v[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    flat_store_b64 v[2:3], v[0:1]
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr %out, i64 %index
  %tmp0 = atomicrmw volatile udec_wrap ptr %ptr, i64 %in syncscope("agent") seq_cst, !noalias.addrspace !0
  store i64 %tmp0, ptr %out2
  ret void
}

!0 = !{i32 5, i32 6}
