/* Bluefish HTML Editor
 * compatibility.c
 *
 * Copyright (C) 2014-2026 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "bluefish.h"

#if !GLIB_CHECK_VERSION(2,28,0)
void g_list_free_full(GList *list,GDestroyNotify free_func)
{
	GList *tmplist;
	for (tmplist = g_list_first(list);tmplist;tmplist=tmplist->next) {
		free_func(tmplist->data);
	}
	g_list_free(list);
}
#endif

#ifndef HAVE_STRCASESTR
#include <ctype.h>
char *strcasestr(const char *a, const char *b)
{
	size_t l;
	char f[3];

	snprintf(f, sizeof(f), "%c%c", tolower(*b), toupper(*b));
	for (l = strcspn(a, f); l != strlen(a); l += strcspn(a + l + 1, f) + 1)
		if (strncasecmp(a + l, b, strlen(b)) == 0)
			return(a + l);
	return(NULL);
}
#endif

#if !GLIB_CHECK_VERSION(2,40,0)
gboolean
g_str_is_ascii(const gchar *str)
{
	gsize i;
	for (i = 0; str[i]; i++)
	if (str[i] & 0x80)
		return FALSE;
	return TRUE;
}

gchar *
g_str_to_ascii_minimal(const gchar *pattern)
{
	gsize i=0, j=0;
	gchar *retval = g_malloc(strlen(pattern));
	while(pattern[i]) {
		if (pattern[i] & 0x80)
			retval[j]=pattern[i];
			j++;
		i++;
	}
	retval[i] = '\0';
	return retval;
}

#endif

#if !GLIB_CHECK_VERSION(2,76,0)
gchar *
g_string_free_and_steal (GString *string)
{
	return g_string_free (string, FALSE);
}
#endif


#if GTK_MAJOR_VERSION < 3
GtkWidget *compat_gridtable_new(guint rows,guint columns,gboolean homogeneous) {
	return gtk_table_new(rows, columns, homogeneous);
}

void compat_gridtable_attach(GtkWidget *grid, GtkWidget *child, gint left, gint top, gint width, gint height)
{
	gtk_table_attach(GTK_TABLE(grid), child,left, left + width,top, top + height,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,0, 0);
}

void compat_gridtable_set_row_spacing(GtkWidget *grid, guint spacing)
{
	gtk_table_set_row_spacings(GTK_TABLE(grid), spacing);
}

void compat_gridtable_set_column_spacing(GtkWidget *grid, guint spacing)
{
	gtk_table_set_col_spacings(GTK_TABLE(grid), spacing);
}
#else
GtkWidget *compat_gridtable_new(guint rows,guint columns,gboolean homogeneous) {
	return gtk_grid_new();
}

void compat_gridtable_attach(GtkWidget *grid, GtkWidget *child, gint left, gint top, gint width, gint height)
{
	gtk_grid_attach(GTK_GRID(grid), child,left, top, width, height);
}

void compat_gridtable_set_row_spacing(GtkWidget *grid, guint spacing)
{
	gtk_grid_set_row_spacing(GTK_GRID(grid), spacing);
}

void compat_gridtable_set_column_spacing(GtkWidget *grid, guint spacing)
{
	gtk_grid_set_column_spacing(GTK_GRID(grid), spacing);
}
#endif /* GTK_MAJOR_VERSION < 3 */